import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import ddf.minim.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class sannidemoni extends PApplet {

public void init()
{
  frame.removeNotify();
  frame.setUndecorated(true);
  frame.addNotify();
  super.init();
}

// Ajastukseen muuttujia
int lastMillis = 0; // edellisen framen millis() arvo millisekunneissa
int deltaMillis = 0; // edellisen framen ja nykyisen framen millis() arvojen EROTUS millisekunneissa
float deltaSeconds = 0; // edellisen framen ja nykyisen frame arvojen EROTUS sekunneissa
int partMillis = 0; // ajettavan efektin millis() arvo (alkaa nollasta kun efekti vaihtuu)
int fullMillis = 0; // koko demon millis() arvo

boolean setupped[] = new boolean[100]; // Taulukko jossa pidet\u00e4\u00e4n kirjaa mille demon palaselle kutsuttu jo setup()
PFont debugFont = null; // Fontti debuggaustekstei varten


Minim minim;
AudioPlayer bmusic;
float [] buffersizeL = new float[1024];
float [] buffersizeR = new float[1024];
float speed = 0.4f;
float trans [] = new float [1024];

// Demon osioita (toteuttavat DemoPart interfacen)
Circles circles;
Starfield starfield;
TokaEfekti tokaEfekti;
FadeIn fadeIn;
FadeOut fadeOut;
Cube cube;


public void setup() {
  // Laitoin nyt size():lle resoksi 1280x720 (HD ready) joka voisi olla hyv\u00e4 reso jos pakottaa yhteen.
  // Toinen hyv\u00e4 ois 1920x1080 (Full-HD) jos jaksaa py\u00f6ritt\u00e4\u00e4.
  //
  // Jos taas haluat tehd\u00e4 resoluutioriippumatonta, niin laita t\u00e4h\u00e4n: displayWidth, displayHeight,
  // mutta muista sit kans testailla usealla.
  //
  // Starfield oli ainut efekti joka oli selke\u00e4sti tehty 800x600 resoluutioon. Se kantsii fiksaa!
  size(displayWidth, displayHeight, P3D);
  frameRate(30); // framerate 60 ois ideaali ja n\u00e4ytt\u00e4is sulavemmalta, mutta 
  lastMillis = millis();

  // Ladataan debugfontti (joudut generoimaan t\u00e4n valikosta "Tools / Create Font..." tai vaihtamaan toiseksi)
  debugFont = loadFont("SansSerif-24.vlw");

  // Nollataan setupped taulukko
  for (int i=0; i<setupped.length; i++) setupped[i] = false;

  // Luodaan olio-instanssit demon osioista
  circles = new Circles();
  starfield = new Starfield();
  tokaEfekti = new TokaEfekti();
  fadeIn = new FadeIn();
  fadeOut = new FadeOut();
  cube = new Cube();
  smooth();
  minim = new Minim(this);
  bmusic = minim.loadFile("owlification.mp3", 1024);
  bmusic.play();
}


public void draw() {
  // Lasketaan ajan kulkua
  int nowMillis = millis();
  deltaMillis = nowMillis - lastMillis;
  deltaSeconds = (float)deltaMillis / 1000.0f;


  int sceneNo = 0; // juokseva numero mill\u00e4 pidet\u00e4\u00e4n demon osasista kirjaa


  // tokaefekti
  if (fullMillis >= 0 && fullMillis < 19000) {
    if (setupped[sceneNo] == false) { // Tehd\u00e4\u00e4n-vain-kerran alustus t\u00e4lle sektiolle
      tokaEfekti.setup();
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    tokaEfekti.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;

  // fade out tokaefekti
  if (fullMillis >= 16000 && fullMillis < 19000) {
    if (setupped[sceneNo] == false) { // Tehd\u00e4\u00e4n-vain-kerran alustus t\u00e4lle sektiolle
      fadeOut.setup(3000, 0, 0, 0); // fade length 3000 ms, color(0, 0, 0)
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    fadeOut.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;

  // cube
  if (fullMillis > 19000 && fullMillis < 29500) {
    if (setupped[sceneNo] == false) { // Tehd\u00e4\u00e4n-vain-kerran alustus t\u00e4lle sektiolle
      cube.setup();
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    cube.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;

  // fade in cube from black
  if (fullMillis >= 19000 && fullMillis < 21000) {
    if (setupped[sceneNo] == false) { // Tehd\u00e4\u00e4n-vain-kerran alustus t\u00e4lle sektiolle
      fadeIn.setup(2000, 0, 0, 0); // fade length 2000 ms, color(0, 0, 0)
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    fadeIn.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;


  // circles
  if (fullMillis >= 29500 && fullMillis < 42000) {
    if (setupped[sceneNo] == false) { // Tehd\u00e4\u00e4n-vain-kerran alustus t\u00e4lle sektiolle
      circles.setup();
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    circles.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;

  // starfield
  if (fullMillis >= 42000 && fullMillis < 73000) {
    if (setupped[sceneNo] == false) { // Tehd\u00e4\u00e4n-vain-kerran alustus t\u00e4lle sektiolle
      starfield.setup();
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    starfield.draw(deltaSeconds, deltaMillis, partMillis, fullMillis); //(huomaa kuutio sen osana, se tulee tokaefektin j\u00e4lkeen??)
  }
  sceneNo++;

  // starfield
  //if (fullMillis >= 50000 && fullMillis < 60000) {
  //  if (setupped[sceneNo] == false) { // Tehd\u00e4\u00e4n-vain-kerran alustus t\u00e4lle sektiolle
     // starfield.setup();
     // partMillis = 0;
    //  setupped[sceneNo] = true;
   // }
  //  starfield.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
 // }
 // sceneNo++;

  // circles
  if (fullMillis >= 73000 && fullMillis < 95000) {
    if (setupped[sceneNo] == false) { // Tehd\u00e4\u00e4n-vain-kerran alustus t\u00e4lle sektiolle
      circles.setup();
      partMillis = 0;
      setupped[sceneNo] = true;
    }
    circles.draw(deltaSeconds, deltaMillis, partMillis, fullMillis);
  }
  sceneNo++;

  // t\u00e4s vaiheessa demo loppuu
  if (fullMillis > 92000) {
    background(0, 0, 0);
    exit();
  }


  // Piirret\u00e4\u00e4n debug infoa (kommentoi lopullisessa veke!)
  hint(DISABLE_DEPTH_TEST);
  camera(); //reset camera
  perspective(); // reset perspective
  fill(255, 255, 255);
  textFont(debugFont);
 // text(round(frameRate)+" FPS", 25, 50);
  //text("partMillis = "+partMillis, 25, 80);
 // text("fullMillis = "+fullMillis, 25, 110);
  hint(ENABLE_DEPTH_TEST);


  // Lasketaan lis\u00e4\u00e4 ajan kulkua
  partMillis += deltaMillis;
  fullMillis += deltaMillis;
  lastMillis = nowMillis;
}


public boolean sketchFullscreen() {
  return true;
}



class Circles
{

  Circles() {
  }


  public void setup() {
  }


  public void draw(float deltaSeconds, int deltaMillis, int partMillis, int fullMillis) {
    background(0,0,0);
    circles(1, partMillis);
 //   if (partMillis > 15000) circles(1, partMillis);
  }


  public void circles(int mode, int partMillis) {
   if (mode == 0) {
      int homo = 20;
      for (int i = 0; i < homo; i++) {
        int r = 40; int g = 69; int b = 20;
        r += tan(i+partMillis*0.001f)*64; g += sin(i+partMillis*0.01f)*64; b += cos(i+partMillis*0.001f)*64;
        stroke(r,g,b,255);
        strokeWeight(20);
        noFill();
        int radius = 0;
        double speed = 0.001f;
        double zoom = width/5*sin(partMillis*0.001f);
        radius+=sin((float)(partMillis*speed+i))*zoom;
        radius+=partMillis*0.001f;
        double keski = width/2;
        double keski2 = height/2;
        keski += cos((float)(partMillis*speed+i))*width/8;
        ellipse((float)keski,(float)keski2,(float)radius,(float)radius); 
      } 
    } else if (mode == 1) {
      int homo = 20;
      for (int i = 0; i < homo; i++) {
        int r = 40; int g = 69; int b = 20;
        r += tan(i+partMillis*0.001f)*64; g += sin(i+partMillis*0.01f)*64; b += cos(i+partMillis*0.001f)*64;
        stroke(r,g,b,255);
        strokeWeight(20);
        noFill();
        int radius = 300;
        double speed = 0.001f;
        double zoom = width/5*sin(partMillis*0.001f);
        radius+=sin((float)(partMillis*speed+i))*zoom;
        radius-=partMillis*0.03f;
        if (radius < 0) radius = 0;
        double keski = width/2;
        double keski2 = height/2;
        keski += cos((float)(partMillis*speed+i))*width/8;
        ellipse((float)keski,(float)keski2,(float)radius,(float)radius); 
      }
    }
  }
}


class Cube
{
  Cube() {
  }


  public void setup() {
  }


  public void draw(float deltaSeconds, int deltaMillis, int partMillis, int fullMillis) {
    background(0);
    cube(); 
  }


  public void cube() {
    int rc = 1;
    int gc = 2;
    int bc = 3;
    int ic = 3;
    rc = 64; gc = 130; bc = 14;
    
    strokeWeight(1);
    stroke(0);
    fill(rc,gc,bc, 255);
    pushMatrix();
    translate(width/2, height/2, 0);
    rotateY(1*millis()*0.001f);
    rotateX(1*millis()*0.001f);
    box(250);
    popMatrix();
  }
}


class FadeIn
{
  int lengthMillis;
  int red;
  int green;
  int blue;


  FadeIn() {
  }


  public void setup(int lengthMillis, int red, int green, int blue) {
    this.lengthMillis = lengthMillis;
    this.red = red;
    this.green = green;
    this.blue = blue;
  }


  public void draw(float deltaSeconds, int deltaMillis, int partMillis, int fullMillis) {
    int alpha = (int)(255.0f - 255.0f * ((float)partMillis / (float)this.lengthMillis));

    println("alpha = "+alpha);
    if (alpha > 0) {
      println("drawing!");
      // piirr\u00e4 kaiken p\u00e4\u00e4lle ja nollaa kamera-asetukset
      hint(DISABLE_DEPTH_TEST);
      camera(); //reset camera
      perspective(); // reset perspective

      noStroke();
      fill(red, green, blue, alpha);
      rectMode(CORNER);
      rect(0, 0, width, height);

      // \u00e4l\u00e4 en\u00e4\u00e4 piirr\u00e4 kaiken p\u00e4\u00e4lle
      hint(ENABLE_DEPTH_TEST);
    }
  }
}


class FadeOut
{
  int lengthMillis;
  int red;
  int green;
  int blue;


  FadeOut() {
  }


  public void setup(int lengthMillis, int red, int green, int blue) {
    this.lengthMillis = lengthMillis;
    this.red = red;
    this.green = green;
    this.blue = blue;
  }


  public void draw(float deltaSeconds, int deltaMillis, int partMillis, int fullMillis) {
    int alpha = (int)(255.0f * ((float)partMillis / (float)this.lengthMillis));

    if (alpha > 0) {
      // piirr\u00e4 kaiken p\u00e4\u00e4lle ja nollaa kamera-asetukset
      hint(DISABLE_DEPTH_TEST);
      camera(); //reset camera
      perspective(); // reset perspective

      noStroke();
      fill(red, green, blue, alpha);
      rectMode(CORNER);
      rect(0, 0, width, height);

      // \u00e4l\u00e4 en\u00e4\u00e4 piirr\u00e4 kaiken p\u00e4\u00e4lle
      hint(ENABLE_DEPTH_TEST);
    }
  }
}


class Starfield
{
  int numStars = 100;
  int layers = 3;
  Star[] stars = new Star[numStars];
  int r;
  int g;
  int b;


  Starfield() {
  }


  public void setup() {
    background(0);
    stroke(255);
  
    for(int i=0; i<numStars-1; i++) {
      stars[i] = new Star();
      stars[i].init(this);
    }
  }


  public void draw(float deltaSeconds, int deltaMillis, int partMillis, int fullMillis) {  
    background(0);
    
    for(int i=0; i<numStars-2; i++) {
      
      fill(0);
      strokeWeight(8);
      r = 40; g = 69; b = 20;
        r += tan(i+partMillis*0.001f)*64; g += sin(i+partMillis*0.01f)*64; b += cos(i+partMillis*0.001f)*64;
        stroke(r,g,b,255);
      ellipse((float)stars[i].x, (float)stars[i].y, 60*cos(partMillis*0.001f), 60*sin(partMillis*0.001f));
      stars[i].update(); 
    
    }
  }
}


class Star
{  
  public Starfield owner;
  public int x, y, c;
  
  public Star() {
    
  }
  
  public void init(Starfield starfield) {
    this.owner = starfield;
    this.x = (int)random(0, width+10);
    this.y = (int)random(0, height-1);
    this.c = (int)random(0, this.owner.layers);
  }
  
  public void update() {
    
    if(this.x <= -10 && partMillis < 1) {
      this.x = width-1;
      this.y = (int)random(0, height-1);
      this.c = (int)random(0, this.owner.layers);
    }
    
   this.x-= this.c+1;
   this.x -= this.c+1;
  }
}



class TokaEfekti
{
  int unit = 50;
  float scrollX;
  int count;
  Module[] mods;
  PFont font;


  TokaEfekti() {
  }


  public void setup() {
    noStroke();
    int wideCount = width / unit;
    int highCount = height / unit;
    scrollX = width - 60;
    count = wideCount * highCount;
    mods = new Module[count];
    font = loadFont("ARDESTINE-48.vlw"); // Vaihda takas haluamaksesi fontiksi jota mulla ei ollut "ARDESTINE-48.vlw"
  
    int index = 0;
    for (int y = 0; y < highCount; y++) {
      for (int x = 0; x < wideCount; x++) {
        mods[index++] = new Module(x*unit, y*unit, unit/2, unit/2, random(0.5f, 0.8f), unit);
      }
    }
  }


  public void draw(float deltaSeconds, int deltaMillis, int partMillis, int fullMillis) {
    textFont(font, 40);
    background(0);
    for (int i = 0; i < count; i++) {
      mods[i].update();
      if (partMillis < 19000)   mods[i].draw();
    }

   fill(0, 0, 0);
   text ("DemoPart aika on: " +partMillis, 10, 50, 100);
  
if (partMillis > 3000 && partMillis < 6000) text ("Owlification presents Hello World", width/2 - 300, height/2, 100);
if (partMillis > 5000 && partMillis < 8000) text ("At Stream 10", width/2, height/2+200, 100);
if (partMillis > 7000 && partMillis < 10000) text ("code by sanni and zov", width/2 - 400, 200, 100); 
if (partMillis > 9000 && partMillis < 12000) text ("music by zov", width/2 - 400, height/2+200, 100); 
if (partMillis > 11000 && partMillis < 17000) text ("greetings to", width/2, height/2, 100); 
if (partMillis > 13000 && partMillis < 17000) text ("PwP", width/2 - 400, height/2+200, 100);
if (partMillis > 13500 && partMillis < 17000) text ("ISO", width/2 - 100, height/2+200, 100); 
if (partMillis > 14000 && partMillis < 17000) text ("trilobit", width/2 + 200, height/2+200, 100);
   }
   //else scrollX = width;
  }







class Module
{
  int xOffset;
  int yOffset;
  float x, y;
  int unit;
  int xDirection = 1;
  int yDirection = 1;
  float speed; 
  float r;
  float g;
  float b;
  float i;

  
  // Contructor
  Module(int xOffsetTemp, int yOffsetTemp, int xTemp, int yTemp, float speedTemp, int tempUnit) {
    xOffset = xOffsetTemp;
    yOffset = yOffsetTemp;
    x = xTemp;
    y = yTemp;
    speed = 0;
    unit = tempUnit;
  }

  
  // Custom method for updating the variables
  public void update() {
    x = x + (speed * xDirection);
    if (x >= unit || x <= 0) {
      xDirection *= -1;
      x = x + (1 * xDirection);
      y = y + (1 * yDirection);
    }
    if (y >= unit || y <= 0) {
      yDirection *= -1;
      y = y + (1 * yDirection);
    }
  }

  
  // Custom method for drawing the object
  public void draw() {
    noFill();
    r = 1;
    g = 2;
    b = 3;
    i = 30;
    ellipse(xOffset + x, yOffset + y, 6*millis()*0.003f, 6*millis()*0.003f);
    r = abs(i+millis()*0.001f)+40;
    g = abs(i+millis()*0.001f)+200; 
    b = abs(i+millis()*0.001f)+40;
      stroke(r,g,b,i);
      strokeWeight(30);
  }
}

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--full-screen", "--bgcolor=#666666", "--hide-stop", "sannidemoni" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
